package net.minecraft.client.entity;

import jamezo97.clonecraft.dna.Gene;
import jamezo97.clonecraft.dna.GenePool;
import jamezo97.clonecraft.dna.IModifiable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
@SideOnly(value = Side.CLIENT)
public class CCEntityOtherPlayerMP extends EntityOtherPlayerMP implements IModifiable, IEntityAdditionalSpawnData{

	public CCEntityOtherPlayerMP(World par1World, String par2Str) {
		super(par1World, par2Str);
		genePool = new GenePool(this);
		this.isDead = false;
		this.setSize(0.8f, 1.62f);
	}
	
	public CCEntityOtherPlayerMP(EntityOtherPlayerMP player) {
		super(player.worldObj, player.username);
		genePool = new GenePool(this);
		NBTTagCompound nbt = new NBTTagCompound();
		player.writeToNBT(nbt);
		this.readFromNBT(nbt);
		this.entityId = player.entityId;
		this.setSize(0.8f, 1.62f);
	}
	
	float baseSizeX = 0.6F, baseSizeY = 1.8F, geneScaling = 1.0F;
	
	GenePool genePool;
	
	public void onUpdate(){
		if(ticksExisted < 2)return;
		yOffset = 1.62f;
		ySize = 1.62f;
		genePool.onUpdate();
		super.onUpdate();
		
//		boundingBox.setBounds(par1, par3, par5, par7, par9, par11)
	}
	
	public void setPositionAndRotation(double par1, double par3, double par5, float par7, float par8)
    {
        this.prevPosX = this.posX = par1;
        this.prevPosY = this.posY = par3;
        this.prevPosZ = this.posZ = par5;
        this.prevRotationYaw = this.rotationYaw = par7;
        this.prevRotationPitch = this.rotationPitch = par8;
//        System.out.println("Set 0");
//        this.ySize = 0.0F;
        double d3 = (double)(this.prevRotationYaw - par7);

        if (d3 < -180.0D)
        {
            this.prevRotationYaw += 360.0F;
        }

        if (d3 >= 180.0D)
        {
            this.prevRotationYaw -= 360.0F;
        }

        this.setPosition(this.posX, this.posY, this.posZ);
        this.setRotation(par7, par8);
    }
	
	public void setDead(){
		super.setDead();
		Thread.dumpStack();
	}
	
	@Override
	public float getBaseStepHeight() {
		return 0.5f;
	}
	
	@Override
	public float getBaseYOffset() {
		return 1.62f;
	}
	
	@Override
	public int getGeneStrength(Gene gene) {
		return genePool.getGeneStrength(gene);
	}

	@Override
	public void setGene(Gene gene, int level) {
		genePool.setGene(gene, level);
	}

	@Override
	public boolean removeGene(Gene gene) {
		return genePool.removeGene(gene);
	}

	@Override
	public boolean hasGene(Gene gene) {
		return genePool.hasGene(gene);
	}

	@Override
	public GenePool getGenePool() {
		return genePool;
	}

	@Override
	public void setGeneScaling(float scale) {
		geneScaling = scale;
	}

	@Override
	public float getGeneScaling() {
		return geneScaling;
	}

	@Override
	public float getBaseXSize() {
		return baseSizeX;
	}

	@Override
	public float getBaseYSize() {
		return baseSizeY;
	}

	@Override
	public boolean shouldApplySizeChange() {
		return true;
	}

	@Override
	public void readEntityFromNBT(NBTTagCompound nbt) {
		super.readEntityFromNBT(nbt);
		genePool.readFromNBT(nbt);
	}

	@Override
	public void writeEntityToNBT(NBTTagCompound nbt) {
		super.writeEntityToNBT(nbt);
		genePool.writeToNBT(nbt);
	}

	@Override
	public void writeSpawnData(ByteArrayDataOutput data) {
		genePool.writeSpawnData(data);
	}

	@Override
	public void readSpawnData(ByteArrayDataInput data) {
		genePool.readSpawnData(data);
	}



	public float getBrightness(float par1)
    {
        int i = MathHelper.floor_double(this.posX);
        int j = MathHelper.floor_double(this.posZ);

        if (this.worldObj.blockExists(i, 0, j))
        {
            double d0 = (this.boundingBox.maxY - this.boundingBox.minY) * 0.66D;
            int k = MathHelper.floor_double(this.posY + d0);
            return this.worldObj.getLightBrightness(i, k, j);
        }
        else
        {
            return 0.0F;
        }
    }
	
	@SideOnly(Side.CLIENT)
    public int getBrightnessForRender(float par1)
    {
        int i = MathHelper.floor_double(this.posX);
        int j = MathHelper.floor_double(this.posZ);

        if (this.worldObj.blockExists(i, 0, j))
        {
            double d0 = (this.boundingBox.maxY - this.boundingBox.minY) * 0.66D;
            int k = MathHelper.floor_double(this.posY + d0);
            return this.worldObj.getLightBrightnessForSkyBlocks(i, k, j, 0);
        }
        else
        {
            return 0;
        }
    }

}
